<?php 
/*------------------------------------------------
 * генератор XML for Google Merchant Center 2019-03-28
 * Copyright © FinBoss 2019
 * finboss.ua@gmail.com 
 *
 * управляющий модуль
 *
 * License: Commercial open source software (COSS) 
 *------------------------------------------------
 */

	header('Content-Type: text/html; charset=utf-8');
	
	// контроль доступа по IP
	$a_allow = false;
	if (is_file('.allowed_ip')){
		$a_ips = file('.allowed_ip');
		
		foreach ($a_ips as $a_ip){
			$a_ip = trim($a_ip);
			if (strpos($a_ip, '*') !== false){
				
				// process 127.0.*.*
				
				$remote = explode('.', $_SERVER['REMOTE_ADDR']);
				$a = explode('.', $a_ip);
				
				$true_count = 0;
				for ($i=0;$i<4;$i++){
					switch ($i){
						case 0:
						case 1:
							if ($remote[$i] != $a[$i]){
								break 2;
							}else{
								$true_count++;
							}
							break;
						case 2:
						case 3:
							if ($a[$i] == '*'){
								// пропускаем
								$true_count++;
							}else{
								if ($remote[$i] != $a[$i]){
									break 2;
								}else{
									$true_count++;
								}
							}
						
					}
				}
				if ($true_count == 4){
					$a_allow = true;
					break;
				}
				
			}else{
				if ($_SERVER['REMOTE_ADDR'] == trim($a_ip)){
					$a_allow = true;
					break;
				}
			}
		}
		
	}
	if ($a_allow === false){
		die('доступ для IP '.$_SERVER['REMOTE_ADDR'].' заблокирован');
	}
	
	error_reporting (E_ALL);
	date_default_timezone_set ('Europe/Kiev');
	
	$title = "Генератор XML для Google Merchant Center";

?>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf8" >
<title><?php echo $title; ?></title>
</head>
<body style="font-family:Trebuchet MS; font-size: 10pt;" bgcolor="#FEF4EB">

<table width="100%" bgcolor="#416e98">
<tr valign="middle">
<td><span style="font-size:25px; color:#FFF; font-family:Trebuchet MS"><?php echo $title; ?></span></td>
<td align="right"><span style="font-size:15px; color:#FFF; font-family:Trebuchet MS"></span></td>
</tr>
</table>
<center>
<br/>

<?php 
	if (isset($_GET['mode'])){
		if ($_GET['mode'] == 'test'){
			if (is_file('../xml/gmc.xml')){
				$size = filesize('../xml/gmc.xml');
				$data = simplexml_load_file('../xml/gmc.xml');
				if (is_object($data)){
					$date = date('Y-m-d H:i:s', filectime('../xml/gmc.xml'));
					$items = $data->channel->item;
					echo "Файл сгенерирован $date <br/>\r\n";
					echo "Размер файла $size <br/>\r\n";
					echo "Всего товаров ".count($items)." <br/>\r\n";
					
					die;
				}else{
					echo 'Файл xml/gmc.xml содержит ошибки';
				}
			}else{
				echo 'Файл xml/gmc.xml не найден';
			}
		}
		die;
	}
?>


<table width="70%">
<tr valign="middle">
<td align="center"><a href="setup.php" target="_blank">Настройка параметров</a></td>
</tr>
<tr>
<td align="center"><hr /></td>
</tr>
<tr valign="middle">
<td align="center"><a href="set_categories.php" target="_blank">Выбор категорий и товаров</a></td>
</tr>
<tr>
<td align="center"><hr /></td>
</tr>
<tr>
<td align="center"><a href="gmc.php?start=now" target="_blank">Генерировать файл</a></td>
</tr>
<tr>
<td align="center"><hr /></td>
</tr>

<tr>
<td align="center">
<?php 
	if (is_file('../xml/gmc.xml')){
		$size = filesize('../xml/gmc.xml');
?>
<a href="../xml/gmc.xml" target="_blank">Просмотреть последний сгенерированный файл XML</a><br/>
Размер файла, байт <?php echo number_format((float)$size, 0, ' ', ' '); ?>
<?php 
	}
?>
</td>
</tr>
<tr><td align="center"><hr/></td></tr>
<tr>
<td align="center">
<?php 
	if (is_file('../xml/gmc.xml')){
?>
<a href="index.php?mode=test" target="_blank">Проверить последний сгенерированный файл XML</a><br/>
<?php 
	}
?>
</td>
</tr>
<tr>
<td align="center"><hr /></td>
</tr>
<tr>
<td align="center"><a href="log/index.php" target="_blank">Отчет</a></td>
</tr>
<tr valign="middle">
<td align="center"><hr /></td>
</tr>
<tr valign="middle">
<td align="center"><a target=_blank href=phpinfo.php>Информация о сервере</a></td>
</tr>
<tr valign="middle">
<td align="center"><hr /></td>
</tr>
<tr valign="middle">
<td align="center"><a target=_blank href=show_license.php>Проверить лицензию</a></td>
</tr>
<tr valign="middle">
<td align="center"><hr /></td>
</tr>
</table>

</center>
</body>
</html>
